// STVS feedback window – Contact us form
const CONTACT_EMAIL = "stories.to.voices.studio@gmail.com";

document.addEventListener("DOMContentLoaded", () => {
  const params = new URLSearchParams(window.location.search);
  const pageUrl = params.get("url") || "";

  const urlEl = document.getElementById("stvs-fb-url");
  if (urlEl && pageUrl) urlEl.value = pageUrl;

  const form = document.getElementById("stvs-feedback-form");
  const mailtoLink = document.getElementById("stvs-mailto-link");
  if (!form || !mailtoLink) return;

  form.addEventListener("submit", (e) => {
    e.preventDefault();
    const description = (document.getElementById("stvs-fb-description") || {}).value || "";
    const pageUrlVal = (document.getElementById("stvs-fb-url") || {}).value || "";
    const userEmail = (document.getElementById("stvs-fb-email") || {}).value || "";
    const subject = "STVS Feedback: " + (description.slice(0, 40).trim() || "User feedback");
    const body = [
      "Please describe your issue in detail below.",
      "",
      "--- Problem description ---",
      description,
      "",
      "--- Page URL ---",
      pageUrlVal,
      "",
      "--- Your email ---",
      userEmail
    ].join("\n");
    mailtoLink.href =
      "mailto:" + CONTACT_EMAIL + "?subject=" + encodeURIComponent(subject) + "&body=" + encodeURIComponent(body);
    mailtoLink.click();
    form.reset();
    if (urlEl && pageUrl) urlEl.value = pageUrl;
  });
});
